<?php
/***************************
 * licence GPL v3

MYProgram is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

MYProgram is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with MYProgram; if not, see http://www.gnu.org/licenses/.

Merci à https://www.phpbb-fr.com pour son aide

Auteur : Bernard SIAUD
Adresse électronique  : troumad@siaud.org

 *  Entre les balises [des] et [/des]
 * voici les éléments qui peuvent additionnés ou soustraits :
 * {nombre de dés}d{nombre de faces}
 * {nombre de dés}d{nombre de faces}m{nombre de dés de malus}
 * {nombre de dés}d{nombre de faces}b{nombre de dés de bonus}
 * {bonus ou malus final}
 * exemple :
 * [des]3d6-2d6b1+3d10m2+13[/des]
 * ceci donne : 3d6 : la somme de 3 dés 6
 * moins 2d6b1 la somme des 2 meilleurs dés 6 sur un tirage de 3=2+1 dé
 * plus 3d10m2 la somme 3 plus mauvais dés 10 sur un tirage de 5=(3+2) dés
 * plus +13
 * ***************************/


namespace troumad\des\event;

use phpbb\event\data;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class Listener implements EventSubscriberInterface
{
    public static function getSubscribedEvents()
    {
        return [
        // Le texte est encore brut (BB‑code). On le transforme avant l’enregistrement.
        'core.posting_modify_message_text' => 'process_dice_rolls',
        // On empêche l’édition ultérieure.
        'core.viewtopic_modify_post_row' => 'protect_dice_posts',
        // On vérifie l'intégralité du message
		'core.modify_text_for_display_before'=> 'decode_post_text'
        ];
    }

    /** @param data $event */
    public function process_dice_rolls(data $event)
    {
        $message = $event['message_parser']->message;

        $message=preg_replace('/\[com_des\].*?\[\/com_des\]/si', '',$message);    
        $message = preg_replace_callback(
                '#\[des\](.*?)\[/des\]#i',
                function ($matches)
                {
                    $formula = trim($matches[1]);
                    $result  = $this->roll_dice($formula);
                    if ($result[0]=='E')
                    {
                        return "❌ $result [des]{$formula}[/des] 🃏";
                    }
                    else
                    {
                        preg_match('/=\s*(\d+)\s*$/', $result, $matches);
                        return "👋 {$formula} → {$result} [com_des]{$matches[1]}[/com_des]🎲";                        
                    }
                },
                $message
            );
        
        $event['message_parser']->message = $message;      // modification par référence
    }
    
    
    
    /** @param data $event */
    public function protect_dice_posts(\phpbb\event\data $event)
    {
        $post_row  = $event['post_row'];
        $post_data = $event['row'];      // données brutes du post (base de données)
        if (isset($post_data['post_text']) && strpos($post_data['post_text'], '<EMOJI seq="1f3b2" tseq="1f3b2">&#127922;</EMOJI>') !== false)
        {
            // Supprimer les liens
            $post_row['U_EDIT']   = false;
            $post_row['U_DELETE'] = false;

            // Et cacher aussi l’icône visuelle
            $post_row['EDIT_IMG']   = '';
            $post_row['DELETE_IMG'] = '';
            
            $event['post_row'] = $post_row;   
        }
        else
        {
        }

    }

    private function roll_dice(string $formula): string
    {
        $parts = preg_split('/(?=[+-])/', $formula);
        
        $totalFinal = 0;
        $ch="";
        foreach ($parts as $part) 
        {
            $part = trim($part); // suppression des espaces en début ou fin de chaîne
            if ($part!=='') // cas signe devant la chaine initiale
            {
                // Détermination du signe
                $sign = 1;
                if ($part[0] === '+')
                {
                    $part = substr($part, 1);
                }
                elseif ($part[0] === '-')
                {
                    $sign = -1;
                    $part = substr($part, 1);
                }
            

                if (!preg_match('/^\s*((\d*)d(\d+)([mb]\d+)*|\d+)\s*$/i', $part, $m))
                {
                    return 'Erreur de jet dans : ' . htmlspecialchars($part);
                }
                

                if (isset($m[2])) // présence d'un nombre de faces
                {
                    $subTotal = 0;
                    $faces = (int)$m[3];
                    $rolls = [];
                    $nb    = $m[2] !== '' ? (int)$m[2] : 1;
                    if (isset($m[4])) // présence d'un bonus ou d'un malus de dé
                    {
                        $var=(int)substr($m[4], 1); // le nombre de dés à rajouter
                        $nbt=$nb+$var;              // le nombre total de dés à tirer
                        for ($i = 0; $i < $nbt; $i++)
                        {
                            $rolls[] = random_int(1, $faces);
                        }
                        $rollString = implode(' , ', $rolls);
                        sort($rolls);
                        if ($m[4][0]==='m' || $m[4][0]==='M')
                        {
                            for ($i=0;$i<$nb;$i++) // on prend les $nb plus petits
                            {
                                $subTotal+=$rolls[$i];
                            }
                        }
                        else
                        {
                            for ($i=$var;$i<$nbt;$i++) // on prend les $nb plus grands 
                            {
                                $subTotal+=$rolls[$i];
                            }
                        }
                        $rollString.=" => $subTotal";
                        
                    }
                    else
                    {

                        for ($i = 0; $i < $nb; $i++)
                        {
                            $jet = random_int(1, $faces);
                            $rolls[] = $jet;
                            $subTotal += $jet;
                        }
                        $rollString = implode(' + ', $rolls);
                    }
                    
                    if ($sign==1)
                    {
                            if ($ch=="")
                            {
                                $ch="($rollString)";
                            }
                            else
                            {
                                $ch.="+($rollString)";
                            }
                            $totalFinal+=$subTotal;                        
                    }
                    else
                    {
                            $ch.="-($rollString)";
                            $totalFinal-=$subTotal;                        
                    }
                    
                }
                else
                {
                    if ($sign<0)
                    {
                        $ch.="-$m[1]";
                        $totalFinal-=(int)$m[1];    
                    }
                    else
                    {
                        $ch.="+$m[1]";
                        $totalFinal+=(int)$m[1];    
                    }
                }
            }
        }
        return "{$ch} = {$totalFinal}";
    }


	public function decode_post_text($event)
	{
        $message_text= $event['text'];
        if (isset($message_text) && strpos($message_text, '<EMOJI seq="1f44b" tseq="1f44b">&#128075;</EMOJI>') !== false)
        {
            $message_text = preg_replace_callback(
                '#\;</EMOJI>(.*?)<EMOJI seq="1f3b2#si',
                function ($matches)
                {
                    $jet = trim($matches[1]);
                    if (preg_match('/(\d+)\s*\[com_des\](.*?)\[\/com_des\]/si', $jet, $matches_))
                    {
                        if ((int)$matches_[1] == (int)$matches_[2] ) // vérification OK
                        {
                            return preg_replace('/\[com_des\].*?\[\/com_des\]/si', '',$matches[0]);
                        }
                        else
                        {
                            return ';</EMOJI>Erreur dans le décompte !<EMOJI seq="1f3b2';
                        }
                    }
                    else
                    {
                        return ';</EMOJI>Décompte oublié !<EMOJI seq="1f432';
                    }
                    return ';</EMOJI>surprise<EMOJI seq="1f432';
                },
                $message_text
            );
            
            // On renvoie le tableau modifié
            $event['text']=$message_text;
        }
        else
        {
            $event['text']=$message_text;
        }
	}    
}
